/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.config;

import net.minecraftforge.common.ForgeConfigSpec;

public final class MutationCommonConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Integer> formula_y_mutate_chance;
    public static final ForgeConfigSpec.ConfigValue<Integer> compound_z_mutate_chance;
    public static final ForgeConfigSpec.ConfigValue<Double> formula_y_cloud_movement_speed;
    public static final ForgeConfigSpec.ConfigValue<Double> compound_z_cloud_movement_speed;
    public static final ForgeConfigSpec.ConfigValue<Double> mutation_cloud_search_range;
    public static final ForgeConfigSpec.ConfigValue<Double> mutation_cloud_search_range_y;
    public static final ForgeConfigSpec.ConfigValue<Boolean> classic_mutations;
    public static final ForgeConfigSpec.ConfigValue<Integer> classic_mutation_min_time;
    public static final ForgeConfigSpec.ConfigValue<Integer> classic_mutation_max_time;

    static {
        BUILDER.comment("Configure Mutant More's mutations on the client and server sides (these changes will affect everyone in the world)! The game needs to be restarted for changes to take effect!");
        formula_y_mutate_chance = BUILDER.comment("\n The chance (in percent) that Formula Y will successfully mutate a mob\n usually set to 10%").defineInRange("Formula Y Mutate Chance", 10, 0, 100);
        compound_z_mutate_chance = BUILDER.comment("\n The chance (in percent) that Compound Z will successfully mutate a mob\n usually set to 100%").defineInRange("Compound Z Mutate Chance", 100, 0, 100);
        formula_y_cloud_movement_speed = BUILDER.comment("\n The speed that a Mutation Cloud spawned by Formula Y follows its target at\n usually set to 0.2").define("Formula Y Cloud Movement Speed", (Object)0.2);
        compound_z_cloud_movement_speed = BUILDER.comment("\n The speed that a Mutation Cloud spawned by Compound Z follows its target at\n usually set to 0.4").define("Compound Z Cloud Movement Speed", (Object)0.4);
        mutation_cloud_search_range = BUILDER.comment("\n The horizontal area that Mutation Clouds search for mobs to mutate in\n usually set to 12.0").define("Mutation Cloud Search Range", (Object)12.0);
        mutation_cloud_search_range_y = BUILDER.comment("\n The vertical area that Mutation Clouds search for mobs to mutate in\n usually set to 6.0").define("Mutation Cloud Search Range Y", (Object)6.0);
        classic_mutations = BUILDER.comment("\n If the mutation process should behave more similarly to in Mutant Creatures and Mutant Beasts\n usually set to false").define("Classic Mutations", false);
        classic_mutation_min_time = BUILDER.comment("\n The minimum amount of time in ticks (20 ticks in a second) that the classic mutation process can take\n usually set to 100 ticks (5 seconds)").define("Classic Mutation Minimum Time", (Object)100);
        classic_mutation_max_time = BUILDER.comment("\n The maximum amount of time in ticks (20 ticks in a second) that the classic mutation process can take\n usually set to 300 ticks (15 seconds)").define("Classic Mutation Maximum Time", (Object)300);
        SPEC = BUILDER.build();
    }
}

